/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data;

import java.nio.IntBuffer;
import java.util.Arrays;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortType;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.TQuad;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.Sorter;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.SplitDirectionData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.StaticSorter;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.TranslucentData;
import net.caffeinemc.mods.sodium.client.util.MathUtil;
import net.caffeinemc.mods.sodium.client.util.sorting.RadixSort;
import net.minecraft.class_4076;

public class StaticNormalRelativeData
extends SplitDirectionData {
    private Sorter sorterOnce;

    public StaticNormalRelativeData(class_4076 sectionPos, int[] vertexCounts, int quadCount) {
        super(sectionPos, vertexCounts, quadCount);
    }

    @Override
    public SortType getSortType() {
        return SortType.STATIC_NORMAL_RELATIVE;
    }

    @Override
    public Sorter getSorter() {
        Sorter sorter = this.sorterOnce;
        if (sorter == null) {
            throw new IllegalStateException("Sorter already used!");
        }
        this.sorterOnce = null;
        return sorter;
    }

    private static StaticNormalRelativeData fromDoubleUnaligned(int[] vertexCounts, TQuad[] quads, class_4076 sectionPos) {
        StaticNormalRelativeData snrData = new StaticNormalRelativeData(sectionPos, vertexCounts, quads.length);
        StaticSorter sorter = new StaticSorter(quads.length);
        snrData.sorterOnce = sorter;
        IntBuffer indexBuffer = sorter.getIntBuffer();
        if (quads.length <= 1) {
            TranslucentData.writeQuadVertexIndexes(indexBuffer, 0);
        } else if (RadixSort.useRadixSort(quads.length)) {
            int[] keys = new int[quads.length];
            for (int q = 0; q < quads.length; ++q) {
                keys[q] = MathUtil.floatToComparableInt(quads[q].getAccurateDotProduct());
            }
            int[] indices = RadixSort.sort(keys);
            for (int i = 0; i < quads.length; ++i) {
                TranslucentData.writeQuadVertexIndexes(indexBuffer, indices[i]);
            }
        } else {
            long[] sortData = new long[quads.length];
            for (int q = 0; q < quads.length; ++q) {
                int dotProductComponent = MathUtil.floatToComparableInt(quads[q].getAccurateDotProduct());
                sortData[q] = (long)dotProductComponent << 32 | (long)q;
            }
            Arrays.sort(sortData);
            for (int i = 0; i < quads.length; ++i) {
                TranslucentData.writeQuadVertexIndexes(indexBuffer, (int)sortData[i]);
            }
        }
        return snrData;
    }

    private static StaticNormalRelativeData fromMixed(int[] vertexCounts, TQuad[] quads, class_4076 sectionPos) {
        StaticNormalRelativeData snrData = new StaticNormalRelativeData(sectionPos, vertexCounts, quads.length);
        StaticSorter sorter = new StaticSorter(quads.length);
        snrData.sorterOnce = sorter;
        IntBuffer indexBuffer = sorter.getIntBuffer();
        int maxQuadCount = 0;
        boolean anyNeedsSortData = false;
        for (int vertexCount : vertexCounts) {
            if (vertexCount == -1) continue;
            int quadCount = TranslucentData.vertexCountToQuadCount(vertexCount);
            maxQuadCount = Math.max(maxQuadCount, quadCount);
            anyNeedsSortData |= !RadixSort.useRadixSort(quadCount) && quadCount > 1;
        }
        long[] sortData = null;
        if (anyNeedsSortData) {
            sortData = new long[maxQuadCount];
        }
        int quadIndex = 0;
        for (int vertexCount : vertexCounts) {
            int i;
            if (vertexCount == -1 || vertexCount == 0) continue;
            int count = TranslucentData.vertexCountToQuadCount(vertexCount);
            if (count == 1) {
                TranslucentData.writeQuadVertexIndexes(indexBuffer, 0);
                ++quadIndex;
                continue;
            }
            if (RadixSort.useRadixSort(count)) {
                int[] keys = new int[count];
                for (int q = 0; q < count; ++q) {
                    keys[q] = MathUtil.floatToComparableInt(quads[quadIndex++].getAccurateDotProduct());
                }
                int[] indices = RadixSort.sort(keys);
                for (int i2 = 0; i2 < count; ++i2) {
                    TranslucentData.writeQuadVertexIndexes(indexBuffer, indices[i2]);
                }
                continue;
            }
            for (i = 0; i < count; ++i) {
                TQuad quad = quads[quadIndex++];
                int dotProductComponent = MathUtil.floatToComparableInt(quad.getAccurateDotProduct());
                sortData[i] = (long)dotProductComponent << 32 | (long)i;
            }
            if (count > 1) {
                Arrays.sort(sortData, 0, count);
            }
            for (i = 0; i < count; ++i) {
                TranslucentData.writeQuadVertexIndexes(indexBuffer, (int)sortData[i]);
            }
        }
        return snrData;
    }

    public static StaticNormalRelativeData fromMesh(int[] vertexCounts, TQuad[] quads, class_4076 sectionPos, boolean isDoubleUnaligned) {
        if (isDoubleUnaligned) {
            return StaticNormalRelativeData.fromDoubleUnaligned(vertexCounts, quads, sectionPos);
        }
        return StaticNormalRelativeData.fromMixed(vertexCounts, quads, sectionPos);
    }
}

